<?php $__env->startSection('page-title',__lang('verify-code')); ?>
<?php $__env->startSection('pageTitle',__lang('verify-code')); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('admin.partials.crumb',[
    'crumbs'=>[
            route('admin.dashboard')=>__('default.dashboard'),
            '#'=>__lang('verify-code')
        ]], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
     <div class="card-header">

         <form action="<?php echo e(route('admin.student.code')); ?>" method="get">
             <input type="search" class="form-control" value="<?php echo e(request()->code); ?>"  name="code" placeholder="<?php echo e(__lang('enter-enrollment-code')); ?>">

         </form>

    </div>
    <div class="card-body">
        <?php if($students): ?>
            <div >
                <table class="table table-hover">
                    <thead>
                    <tr>
                        <th><?php echo e(__lang('code')); ?></th>
                        <th><?php echo e(__lang('student')); ?></th>
                        <th><?php echo e(__lang('course')); ?></th>
                        <th><?php echo e(__lang('enrolled-on')); ?></th>
                        <th  ><?php echo e(__lang('actions')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><span class="label label-success"><?php echo e($row->reg_code); ?></span></td>
                        <td><?php echo e($row->student->user->name); ?> <?php echo e($row->student->user->last_name); ?></td>
                        <td><?php echo e($row->course->name); ?>

                        </td>
                        <td> <?php echo e(getDateString($row->created_at)); ?>

                        </td>
                        <td >
                            <a href="<?php echo e(adminUrl(array('controller'=>'session','action'=>'stats','id'=>$row->id))); ?>" class="btn btn-xs btn-primary btn-equal" data-toggle="tooltip" data-placement="top" data-original-title="<?php echo e(__lang('student-progress')); ?>"><i class="fa fa-chart-bar"></i></a>


                            <button   data-id="<?php echo e($row->student_id); ?>" data-toggle="modal" data-target="#simpleModal" title="Student Details" type="button" class="btn btn-xs btn-primary btn-equal viewbutton"  ><i class="fa fa-user"></i></button>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>

                <?php echo e($students->appends(request()->input())->links()); ?>

            </div><!--end .col-lg-12 -->
        <?php endif; ?>
    </div>
    </div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>

    <!-- START SIMPLE MODAL MARKUP -->
    <div class="modal fade" id="simpleModal" tabindex="-1" role="dialog" aria-labelledby="simpleModalLabel" aria-hidden="true">
        <div class="modal-dialog  modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="simpleModalLabel"><?php echo e(__lang('student-details')); ?></h4>

                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>

                </div>
                <div class="modal-body" id="info">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__lang('close')); ?></button>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <!-- END SIMPLE MODAL MARKUP -->

    <script type="text/javascript">
        $(function(){
            $('.viewbutton').click(function(){
                $('#info').text('Loading...');
                var id = $(this).attr('data-id');
                $('#info').load('<?php echo e(adminUrl(array('controller'=>'student','action'=>'view'))); ?>'+'/'+id);
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/menzon6/public_html/beta/resources/views/admin/student/code.blade.php ENDPATH**/ ?>