@extends('layouts.student')
@section('pageTitle',$pageTitle)
@section('innerTitle',$pageTitle)
@section('breadcrumb')
    @include('admin.partials.crumb',[
    'crumbs'=>[
            route('student.dashboard')=>__lang('dashboard'),
            route('student.test.index')=>__lang('tests'),
            '#'=>$pageTitle
        ]])
@endsection
@section('content')

    <div class="row">
        <div class="col-md-7 offset-3">
            <div class="card">
              <div class="login-brand">
                        <a href="{{ url('/') }}">
                            @if(!empty(setting('image_logo')))
                                <img  alt="logo" width="100"  src="{{ asset(setting('image_logo')) }}" >
                        @else
                                <h1>{{ setting('general_site_name') }}</h1>
                        @endif
                        </a>
                    </div>
                <div class="card-body">
                    <div class="container">
                        @php  if($testRow->show_result==1): @endphp
                        <div class="row">
                            <div class="col-md-4 col-md-offset-3">
                                <h4>{{  __lang('your-score')  }}</h4>
                                <h1>{{  $row->score  }}%</h1>
                            </div>
                            <div class="col-md-4">
                                <h4>{{  __lang('passmark')  }}</h4>
                                <h1>{{  $testRow->passmark  }}%</h1>
                            </div>
                        </div>

                        <div id="testresult" class="row" style="text-align: center; margin-top: 30px">

                            <!--@php  if($row->score >= $testRow->passmark ):  @endphp-->
                            <!--<h1 style="color:green">{{  __lang('you-passed-test')  }}</h1>-->
                            <!--@php  else:  @endphp-->
                            <!--<h1 style="color:red">{{  __lang('you-failed-test')  }}</h1>-->
                            <!--@php  endif;  @endphp-->
                            
                             @php  if($row->score >= $testRow->passmark ):  @endphp
                            <h1 style="color:green">Congratulations on passing MEN ZONE ACADEMY {{  $testRow->name  }}</h1>
                               @php  if($row->test_id == 3 ):  @endphp
                                <h1 style="color:green">Now you are ready to advance to the next level</h1>
                                 @php  endif;  @endphp
                              @php  if($row->test_id == 4):  @endphp
                                <h1 style="color:green">Congratulations on successfully completing the 3 Levels of MEN ZONE ACADEMY Assessment Tests!</h1>
                              @php  endif;  @endphp
                            @php  else:  @endphp
                            <h1 style="color:red">You Have Failed this test,try again.</h1>
                            @php  endif;  @endphp

                        </div>
                        @php  else:  @endphp
                        <div class="row">
                            <h4>{{  __lang('you-completed-test')  }}</h4>
                        </div>

                        @php  endif;  @endphp

                    </div>
                     @php  if($row->score >= $testRow->passmark ):  @endphp
                    <a class="btn btn-primary" href="{{ route('student.test.testCertificate') }}" target="blank">Print Result</a>
                    @php  endif;  @endphp
                    
                   @php  if((!$studentTest->hasTest($row->test_id,$id) || !empty($testRow->allow_multiple))&& ($studentTest->attemptTest($row->test_id,$id) < 3)):  @endphp
                    <a  href="{{  route('student.test.taketest',array('id'=>$row->test_id)) }}" class="btn btn-primary" >Retake Test</a>
                    @php  endif;  @endphp
                </div>
            </div>

        </div>
    </div>

@endsection
