@extends('layouts.auth')
@section('page-title',__lang('login'))
@if($enableRegistration)
@section('page-class')
class="col-12 col-sm-10 offset-sm-1 col-md-8 offset-md-2 col-lg-8 offset-lg-2 col-xl-8 offset-xl-2"
@endsection
@endif
@section('content')


<style>

.login-thiert {width: 57% !important;}
.home-login-btn a {font-size: 12px !important;line-height: 22px !important;color: #fff !important;background-color: #000 !important;
padding: 10px 70px !important;text-decoration: none !important;transition: 0.7s all !important;width: 100% !important;display: block !important;}
.home-login-btn a:hover {background-color: red !important;border-radius: 2% !important;}
.home-login-btn {margin-top: 77px !important;}

@media (max-width: 1199px){

.login-join a {margin-left: 0px !important;}
.login-contact a {padding: 5px 2px 5px 4px !important;}

}

@media (max-width: 992px){

.login-join a {font-size: 9px !important;padding: 5px 5px 5px 5px !important;}
.login-contact a {padding: 5px 2px 5px 4px !important;font-size: 7px !important;}

}

@media (max-width: 767px){

.login-join a {font-size: 12px !important;padding: 8px 8px 8px 8px !important;}
.login-contact a {padding: 8px 8px 8px 8px !important;font-size: 12px !important;}
.login-join {padding-bottom: 20px;}
.home-login-btn {margin-top: 30px !important;}

section .login-join {width: 100% !important;}
section.section .row {justify-content: center !important;}

}


</style>

<div class="card card-primary">
    <div class="card-header"><h4>{{ __lang('login') }}</h4></div>

    <div class="card-body">
        <div id="login-info-box"></div>

        <div class="row">
            <div class="col-md-{{ $enableRegistration ? 6:12 }} mb-5">
                <form method="POST" action="{{ route('login') }}" class="needs-validation"   >
                    @csrf
                    <div class="form-group">
                        <label for="email">{{ __lang('email') }}</label>
                        <input id="email" type="email" class="form-control login-email @error('email') is-invalid @enderror"  name="email" tabindex="1"  value="{{ old('email') }}"   required autofocus autocomplete="email" >

                        <div class="invalid-feedback">
                            {{ __lang('email-required') }}
                        </div>
                        @error('email')
                        <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <div class="d-block">
                            <label for="password" class="control-label">{{ __lang('password') }}</label>
                            <div class="float-right">
                                <a href="{{ route('password.request') }}" class="text-small">
                                    {{ __lang('lost-password') }}
                                </a>
                            </div>
                        </div>
                        <input id="password" type="password" class="form-control login-password @error('password') is-invalid @enderror" name="password" tabindex="2" required  autocomplete="current-password" >
                        <div class="invalid-feedback">
                            {{ __lang('fill-password') }}
                        </div>
                        @error('password')
                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                    </span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <div class="custom-control custom-checkbox">
                            <input type="checkbox" name="remember" class="custom-control-input" tabindex="3" id="remember-me"  {{ old('remember') ? 'checked' : '' }} >
                            <label class="custom-control-label" for="remember-me">{{ __lang('remember-me') }}</label>
                        </div>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-lg btn-block" tabindex="4">
                            {{ __lang('sign-in') }}
                        </button>
                    </div>
                </form>

                @if(setting('social_enable_facebook')==1 || setting('social_enable_google')==1)
                    <div class="text-center mt-4 mb-3">
                        <div class="text-job text-muted">{{ __lang('social-login') }}</div>
                    </div>
                    <div class="row sm-gutters">
                        @if(setting('social_enable_facebook')==1)
                            <div class="col-6">
                                <a href="{{ route('social.login',['network'=>'facebook']) }}" class="btn btn-block btn-social btn-facebook">
                                    <span class="fab fa-facebook"></span> {{ __lang('facebook') }}
                                </a>
                            </div>
                        @endif
                        @if(setting('social_enable_google')==1)
                            <div class="col-6">
                                <a href="{{ route('social.login',['network'=>'google']) }}" class="btn btn-block btn-social btn-google">
                                    <span class="fab fa-google"></span> {{ __lang('google') }}
                                </a>
                            </div>
                        @endif

                    </div>
                @endif
            </div>
            @if($enableRegistration)
            <div class="col-md-6 text-center">
                <h4>{{ __lang('new-user') }}</h4>
                <br>
                <h1><i class="fa fa-user"></i></h1>
                <br>
                <!--<a href="{{ route('register') }}" class="btn btn-primary btn-block btn-lg">{{ __lang('register') }} </a>-->
                <div class="row">
                    <div class="col-md-6">
                        <div class="login-join"> 
                        <a href="{{ route('register') }}">JOIN US NOW</a>
                        </div>
                        </div>
                        <div class="col-md-6">
                            <div class="login-contact"> 
                            <a href="#.">CONTACT OUR TEAM</a>
                            </div>
                            </div>
                            </div>
                          
                              <div class="row">
                                <div class="col-md-12">
                                    <div class="home-login-btn">
                                        <a href="@route('homepage')">HOME</a>
                                    </div>
                                </div>
                            </div>
                            
                            
                            </div>
                            
            
            </div>
            @endif
            <!--<div class="col-md-6">-->
            <!--    <div class="row">-->
            <!--        <div class="col-md-6">-->
            <!--            <div class="login-join"> -->
            <!--            <a href="#.">JOIN US NOW</a>-->
            <!--            </div>-->
            <!--            </div>-->
            <!--            <div class="col-md-6">-->
            <!--                <div class="login-contact"> -->
            <!--                <a href="#.">JOIN US NOW</a>-->
            <!--                </div>-->
            <!--                </div>-->
            <!--                </div>-->
            <!--                </div>-->
            

        </div>

    </div>
</div>
@if($enableRegistration)
<div class="login-thiert">
<div class="login-content-center">
<div class="mt-5 text-muted text-center">
    {{ __lang('dont-have-account') }} <a href="{{ route('register') }}">{{ __lang('create-one') }}</a>
    </div>
</div>
</div>
@endif


@endsection
