<?php

use Stripe\Charge;
use Stripe\Customer;
use Stripe\Stripe;
use App\V2\Model\StudentSessionTable;

function traineasy_pay(){
  $cart = getCart();
  $method = $cart->getPaymentMethod();
  $code = $method->directory;
  $invoice= $cart->getInvoiceObject();
  $user = \Illuminate\Support\Facades\Auth::user();
  //  setBillingDefaults($user);
  $description = __lang('Enrollment for').' '.getCart()->getTotalItems().' '.__lang('items');
  return view("payment.{$code}.views.pay",compact('cart','method','invoice','code','user','description'));
}

function traineasy_callback(){
    $cart = getCart();
    $method = $cart->getPaymentMethod();
    $code = $method->directory;
    $invoice= $cart->getInvoiceObject();
    $user = \Illuminate\Support\Facades\Auth::user();

    if(!request()->isMethod('post'))
    {
        return redirect()->route('cart');
    }

    $token  = request('stripeToken');

    Stripe::setApiKey(paymentOption($code,'secret_key'));

    try{

        $customer = Customer::create([
            'email'=>$user->email,
            'source'=>$token
        ]);

        $charge = Charge::create(array(
            'customer' => $customer->id,
            'amount'   => ($invoice->amount * 100),
            'currency' => strtolower($invoice->currency->country->currency_code)
        ));

        $total = $cart->approve(\Illuminate\Support\Facades\Auth::id());
        $message = __lang('enroll-success-msg',['total'=>$total]);
        flashMessage($message);
        return redirect()->route('student.student.mysessions');

    }
    catch(\Exception $ex){


        flashMessage(__lang('payment-unsuccessful').$ex->getMessage());

        return redirect()->route('cart');
    }


}

function traineasy_ipn(){

}

function traineasy_paynew($code=null,$invoice=null,$user=null)
{
  $code = $code;
  $invoice= $invoice;
  $user =  $user;
  $description = "Admission for menzone";
  return view("payment.{$code}.views.pay_new",compact('invoice','code','user','description'));
}

function traineasy_callback_new($code=null,$invoice=null,$user=null)
{
    //   $code = $code;
    //   $invoice= $invoice;
    //   $user =  $user;
    print_r($code);
    print_r($invoice);
    print_r($user);exit;
   $enableRegistration = true;
         
        if(empty(setting('regis_enable_registration'))){
            $enableRegistration=false;
        }

    $token  = request('stripeToken');

    Stripe::setApiKey(paymentOption($code,'secret_key'));

    try{

        $customer = Customer::create([
            'email'=>$user->email,
            'source'=>$token
        ]);

        $charge = Charge::create(array(
            'customer' => $customer->id,
            'amount'   => ($invoice->amount * 100),
            'currency' => strtolower($invoice->currency->country->currency_code)
        ));

        // $total = $cart->approve(\Illuminate\Support\Facades\Auth::id());
        // $message = __lang('enroll-success-msg',['total'=>$invoice->amount]);
        // return redirect()->route('student.student.mysessions');
        
         $studentSessionTable = new StudentSessionTable();
                $enrollcode =  generateRandomString(5);
                $studentSessionTable->addRecord(array(
                    'student_id'=>$user->student->id,
                    'course_id'=>$invoice->course_id,
                    'reg_code'=>$enrollcode,
                ));
         $message = 'Admission successfull , Login for Further Process';
        flashMessage($message);
        
        
        return tview('auth.login',compact('enableRegistration'));


    }
    catch(\Exception $ex){


        flashMessage(__lang('payment-unsuccessful').$ex->getMessage().' Login and Enroll for Course');

        // return redirect()->route('cart');
        
       return tview('auth.login',compact('enableRegistration'));
    }


}



