<?php

namespace App\Http\Controllers\Site;

use App\Admin;
use App\Article;
use App\Http\Controllers\Controller;
use App\Lib\CronJobs;
use App\Lib\HelperTrait;
use Illuminate\Http\Request;
use App\V2\Model\TestOptionTable;
use App\V2\Model\TestQuestionTable;
use App\V2\Model\SessionTable;
use App\User;
use Illuminate\Support\Facades\Hash;
use App\Currency;
use App\Invoice;

class HomeController extends Controller
{
    use HelperTrait;
    public function index(){

        //check if installation file exists and redirect to install if not
        if(!file_exists('../storage/installed')){
           return redirect('/install');
        }

        return tview('site.home.index');
    }

    public function article($slug){

        $article = Article::where('slug',$slug)->where('enabled',1)->first();
        if(!$article){
          return  abort(404);
        }


        return tview('site.home.article',compact('article'));
    }

    public function contact(){
        $captchaUrl = captcha_src();
        return tview('site.home.contact',compact('captchaUrl'));
    }
    
    public function about(){
        $captchaUrl = captcha_src();
        return tview('site.home.about-us',compact('captchaUrl'));
    }
    
    public function studentresources(){
        $captchaUrl = captcha_src();
        return tview('site.home.studentresources',compact('captchaUrl'));
    }
    
   
    public function admission(){
        $captchaUrl = captcha_src();
        $table = new SessionTable();
        $paginator = $table->getPaginatedCourseRecords(true,null,true,null,null,null,'c');
        $paginator->setCurrentPageNumber((int)request()->get('page', 1));
        $paginator->setItemCountPerPage(30);
        
         
        
        
        return tview('site.home.admission',compact('captchaUrl','paginator'));
    }
    
     public function course_data(Request $request,$id)
     {
        $table = new SessionTable();
        $row = $table->getRecord($id);

        $output = json_encode(['course_data'=>$row,'status'=>true]);
        exit($output);
     }
    
     public function osap(){
        $captchaUrl = captcha_src();
        return tview('site.home.osap',compact('captchaUrl'));
    }
    
     public function financial_assistance(){
        $captchaUrl = captcha_src();
        return tview('site.home.financial-assistance',compact('captchaUrl'));
    }
    
    
    
    
    
     public function certificate(){
        $captchaUrl = captcha_src();
        return tview('site.home.certificate',compact('captchaUrl'));
    }
    
     public function e_learning(){
        $captchaUrl = captcha_src();
        return tview('site.home.e-learning',compact('captchaUrl'));
    }
    
     public function student_kit(){
        $captchaUrl = captcha_src();
        return tview('site.home.student-kit',compact('captchaUrl'));
    }
    
     public function testimonial(){
        $captchaUrl = captcha_src();
        return tview('site.home.testimonial',compact('captchaUrl'));
    }
    
     public function apprenticeship(){
        $captchaUrl = captcha_src();
        return tview('site.home.apprenticeship',compact('captchaUrl'));
    }
    
     public function full_time(){
        $captchaUrl = captcha_src();
        return tview('site.home.full-time-course',compact('captchaUrl'));
    }
    
     public function part_time(){
        $captchaUrl = captcha_src();
        return tview('site.home.part-time-course',compact('captchaUrl'));
    }
    
     public function enrollment(){
        $captchaUrl = captcha_src();
        return tview('site.home.enrollment-dates',compact('captchaUrl'));
    }
    
    public function admission_submit(Request $request)
    {
       
        $data  = $_POST;
        
         $user= User::create([
            'name' => $data['first_name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
            'role_id'=>2
        ]);
        
        
        if($user)
        {
            
          $user->student()->create([
              'mobile_number'=>$data['mobile_number'],
              'social_insaurance'=>isset($data['social_insaurance'])?'1':'',
              'photo_id'=>isset($data['photo_id'])?'1':'',
              'age_group'=>isset($data['age_group'])?'1':'',
              'school_diploma'=>isset($data['school_diploma'])?'1':'',
              'mobile_number1'=>isset($data['mobile_number1'])?$data['mobile_number1']:'',
              'language'=>isset($data['language'])?$data['language']:'',
              'international_student'=>isset($data['international_student'])?$data['international_student']:'',
              'province'=>isset($data['province'])?$data['province']:'',
              'permanent_address'=>isset($data['address'])?$data['address']:'',
               
            ]);
            
            
             $message = __('mails.new-account',[
            'siteName'=>setting('general_site_name'),
            'email'=>$data['email'],
            'password'=>$data['password'],
            'link'=> url('/login')
            ]);
    
            $subject = __('mails.new-account-subj',[
                'siteName'=>setting('general_site_name')
            ]);
            $this->sendEmail($data['email'],$subject,$message);
        
          $invoice = Invoice::create([
                'user_id'=>$user->id,
                'currency_id'=>currentCurrency()->id,
                'amount'=>$data['deposit_amount'],
                'cart' => '',
                'paid'=> 0,
                'payment_method_id'=>1,
                'course_id'=>$data['course']
            ]);
            
            
            $output = json_encode(['id'=>$invoice->id,'status'=>true]);
            exit($output);
        
        }
    }
    
    public function payment_page(Request $request,$id)
    {
        $invoice = Invoice::find($id);
        $user = $invoice->user;
        
            if(!$this->setFunctions()){
            flashMessage(__lang('invalid-gateway'));
            return redirect()->route('cart');
            }
    
            if (!function_exists('traineasy_pay')){
                flashMessage(__lang('invalid-gateway'));
                return redirect()->route('cart');
            }

          return traineasy_paynew('stripe',$invoice,$user);
        
    }
    
    
    public function method(Request $request,$code,$function){
        $this->setFunctions($code);
        if (!function_exists($function)){
            flashMessage(__lang('invalid-gateway'));
            return redirect()->route('cart');
        }

        return $function();

    }


    private function setFunctions($code=null){
        if (!$code){
            $code= 'stripe';
        }

        $file = 'gateways/payment/'.$code.'/functions.php';
        if (file_exists($file)){
            require_once($file);
            return true;
        }
        else{
            return false;
        }
    }
    
     public function callback(Request $request,$code,$id){
        
        $this->setFunctions('stripe');
        if (!function_exists('traineasy_callback_new')){
            flashMessage(__lang('invalid-gateway'));
            // return redirect()->route('cart');
        }
        $invoice = Invoice::find($id);
        $user = $invoice->user;
        
        return traineasy_callback_new($code,$invoice,$user);
    }
    
    
    public function enquiryMail(Request $request)
    {
       $this->validate($request,[
            'name'=>'required',
            'email'=>'required',
            'phone'=>'required',
            'course' => 'required'
        ]);
        
        $subject = "Enquiry Mail ".$request->course;
        // $msg = "New Enquiry mail for ".$request->course ;
        
        if(!empty(setting('general_admin_email')))
        {
            $this->sendEmail(setting('general_admin_email'),$subject,$request->message,['address'=>$request->email,'name'=>$request->name]);
        }
        
        return back()->with('flash_message',__('default.message-sent'));
    }
    
    public function contactMail(Request $request)
    {
       $this->validate($request,[
            'name'=>'required',
            'email'=>'required',
            'phone'=>'required',
            'message' => 'required'
        ]);
        
       
        if(!empty(setting('general_admin_email')))
        {
            $this->sendEmail(setting('general_admin_email'),__('default.contact-form-message'),$request->message,['address'=>$request->email,'name'=>$request->name]);
        }
        
        return back()->with('flash_message',__('default.message-sent'));
    }
    

    public function sendMail(Request $request){
        $this->validate($request,[
            'name'=>'required',
            'email'=>'required',
            'message'=>'required',
            'captcha' => 'required|captcha'
        ]);

        if(!empty(setting('general_admin_email')))
        {
            $this->sendEmail(setting('general_admin_email'),__('default.contact-form-message'),$request->message,['address'=>$request->email,'name'=>$request->name]);
        }

        return back()->with('flash_message',__('default.message-sent'));

    }

    public function privacy(){
        $title= __lang('privacy-policy');
        $content = setting('info_privacy');
        return tview('site.home.info',compact('title','content'));
    }

    public function terms(){
        $title= __lang('terms-conditions');
        $content = setting('info_terms');
        return tview('site.home.info',compact('title','content'));

    }

    public function instructors(){
        $admins = Admin::where('public',1)->whereHas('user',function($query){
            $query->orderBy('name');
        })->get();


        return tview('site.home.instructors',compact('admins'));
    }

    public function instructor(Admin $admin){
        if (empty($admin->public)){
            abort(401);
        }
        return tview('site.home.instructor',compact('admin'));
    }

    public function cron(Request $request,$method)
    {
        set_time_limit(3600);
        //protect ip
        $ip = setting('general_site_ip');
        if(!empty($ip) && trim($ip) != $_SERVER['REMOTE_ADDR']){
            exit('Unauthorized access');
        }

        //process only at 12noon in the first minute
        $hour= date('G');
        $minute = date('i');
        $cHour = setting('general_reminder_hour');
        if($hour != $cHour ){
            exit('Invalid time for cron');
        }

        $jobs= new CronJobs();
        call_user_func([$jobs,$method]);
    }
    
     // Ankita //
    
    public function importTest()
    {
        // echo 'hello help';
        // exit;
        $filename=$_FILES["file"]["tmp_name"];
       
        if($_FILES["file"]["size"] > 0)
        {
            $testQuestionTable = new TestQuestionTable();
            $testOptionTable = new TestOptionTable();
            $file = fopen($filename, "r");
            $count=0;
            $count2=0;
            $wrong_file_upload = 0;
            $date = date('Y-m-d H:i:s');
            while (($uploadData = fgetcsv($file, 10000, ",")) !== FALSE)
            {
               
                if($count>0)
                {     
    //                 'state_name'=> str_replace(["'"], "", trim($uploadData[1])),
				// 		'district_name'=> str_replace(["'"], "", trim($uploadData[0])),
				// 		'lat'=> str_replace(["'"], "", trim($uploadData[2])),
				// 		'lng'=> str_replace(["'"], "", trim($uploadData[3])),
					
					$data = array(
						'test_id'=> 4,
						'question'=> $uploadData[0],
					);

			        $questionId = $testQuestionTable->addRecord($data);
			      
			       
			       if($questionId)
			       {
			           $optionData = [
                            'test_question_id'=>$questionId,
                            'option'=> $uploadData[1]
                        ];

                        if($uploadData[1]==$uploadData[5]){
                            $optionData['is_correct'] = 1;
                        }
                        else{
                            $optionData['is_correct'] = 0;
                        }

                        $testOptionTable->addRecord($optionData);
			       
			            $optionData = [
                            'test_question_id'=>$questionId,
                            'option'=> $uploadData[2]
                        ];

                        if($uploadData[2]==$uploadData[5]){
                            $optionData['is_correct'] = 1;
                        }
                        else{
                            $optionData['is_correct'] = 0;
                        }

                        $testOptionTable->addRecord($optionData);
			       
    			       $optionData = [
                            'test_question_id'=>$questionId,
                            'option'=> $uploadData[3]
                        ];

                        if($uploadData[3]==$uploadData[5]){
                            $optionData['is_correct'] = 1;
                        }
                        else{
                            $optionData['is_correct'] = 0;
                        }

                        $testOptionTable->addRecord($optionData);
			       
    			       $optionData = [
                                'test_question_id'=>$questionId,
                                'option'=> $uploadData[4]
                                
                            ];
    
                            if($uploadData[4]==$uploadData[5]){
                                $optionData['is_correct'] = 1;
                            }
                            else{
                                $optionData['is_correct'] = 0;
                            }
    
                            $testOptionTable->addRecord($optionData);
			       }
			      
                }
                $count++;
            }
        }  
        // echo 'success';
        echo $count;
    
    }
}
